// XISLOutputBrowser.cpp: CXISLOutputBrowser NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ib.h"
#include "XISLOutputBrowser.h"
#include "XISLVar.h"
#include "XISLExcItem.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////
CXISLOutputBrowser::CXISLOutputBrowser()
{
	m_nTagType = ID_TAG_OUTPUT;
	m_nBmpID = IDB_WINDOW;
	m_nOutputType = ID_OUTPUTTYPE_BROWSER;
	m_pParentTag = NULL;
	m_nWidth = 0;
	m_nHeight = 0;
	m_nPosition = 0;
	m_bSize = FALSE;
	m_pSPMapForm = NULL;
	m_strWName = "Main";
}

CXISLOutputBrowser::~CXISLOutputBrowser()
{
	if(m_pSPMapForm)
	{
		InitFormMap();
		delete m_pSPMapForm;
	}
}

CXISLOutputBrowser::CXISLOutputBrowser(const CXISLOutputBrowser &cpXISL)
{
	m_nTagType = cpXISL.m_nTagType;
	m_strXISL = cpXISL.m_strXISL;
	m_rectBMP = cpXISL.m_rectBMP;
	m_nBmpID = cpXISL.m_nBmpID;
	m_htreeItem = cpXISL.m_htreeItem;
	m_pParentTag = cpXISL.m_pParentTag;

	m_nOutputEvent = cpXISL.m_nOutputEvent;
	m_nOutputType = cpXISL.m_nOutputType;

	m_strURI = cpXISL.m_strURI;
	m_strWName = cpXISL.m_strWName;
	m_nWType = cpXISL.m_nWType;
	m_nWidth = cpXISL.m_nWidth;
	m_nHeight = cpXISL.m_nHeight;
	m_nPosition = cpXISL.m_nPosition;
	m_bSize = cpXISL.m_bSize;
	m_pSPMapForm = cpXISL.m_pSPMapForm;
}

CXISLOutputBrowser& CXISLOutputBrowser::operator=(const CXISLOutputBrowser &cpXISL)
{
	if(&cpXISL != this)
	{
		m_nTagType = cpXISL.m_nTagType;
		m_strXISL = cpXISL.m_strXISL;
		m_rectBMP = cpXISL.m_rectBMP;
		m_nBmpID = cpXISL.m_nBmpID;
		m_htreeItem = cpXISL.m_htreeItem;
		m_pParentTag = cpXISL.m_pParentTag;

		m_nOutputEvent = cpXISL.m_nOutputEvent;
		m_nOutputType = cpXISL.m_nOutputType;

		m_strURI = cpXISL.m_strURI;
		m_strWName = cpXISL.m_strWName;
		m_nWType = cpXISL.m_nWType;
		m_nWidth = cpXISL.m_nWidth;
		m_nHeight = cpXISL.m_nHeight;
		m_nPosition = cpXISL.m_nPosition;
		m_bSize = cpXISL.m_bSize;
		m_pSPMapForm = cpXISL.m_pSPMapForm;
	}
	return *this;
}

int CXISLOutputBrowser::GetWidth()
{
	if(m_nOutputEvent != ID_BROWSEREVENT_RESIZE && !m_bSize)
		ASSERT(NULL);
	
	return m_nWidth;
}

int CXISLOutputBrowser::GetHeight()
{
	if(m_nOutputEvent != ID_BROWSEREVENT_RESIZE && !m_bSize)
		ASSERT(NULL);
	
	return m_nHeight;
}

int CXISLOutputBrowser::GetPosition()
{
	if(m_nOutputEvent != ID_BROWSEREVENT_MOVE && !m_bSize)
		ASSERT(NULL);
	
	return m_nPosition;
}

BOOL CXISLOutputBrowser::SetFormMap(LPCTSTR lpszID,LPCTSTR lpszValue)
{
	if(m_pSPMapForm==NULL)
		m_pSPMapForm = new CMapStringToPtr;

	CString strValue = lpszValue;
	CXISLVar *pVar=NULL;
	CXISLExcItem *pExcItem = (CXISLExcItem*)m_pParentTag->GetParentExcTag();
	int nStart = strValue.Find("<value",0);
	if( nStart != -1)
	{
		int nIndex = strValue.Find("expr",0);
		if(nIndex == -1)
		{
			AfxMessageBox("<value>expr܂",MB_OK|MB_APPLMODAL|MB_ICONINFORMATION,0);
			return FALSE;
		}
			
		nIndex = strValue.Find("\"",nIndex);
		int nEnd = strValue.ReverseFind('"');
		strValue = strValue.Mid(nIndex+1,nEnd-nIndex-1);
		pVar = pExcItem->m_pLocalVar->FindVarWithParent(strValue);
		if(pVar == NULL)
		{
			AfxMessageBox("݂Ȃϐw肳܂",MB_OK|MB_APPLMODAL|MB_ICONINFORMATION,0);
			return FALSE;
		}
		pVar->ReferCount(TRUE);
	}
	else
	{
		pVar = new CXISLVar;
		pVar->SetAttribute(lpszValue,"",FALSE,TRUE);
	}
	m_pSPMapForm->SetAt(lpszID,(void*)pVar);
	return TRUE;
}

void CXISLOutputBrowser::InitFormMap()
{
	if(m_pSPMapForm == NULL)
		return;

	CString strID;
	CXISLVar *pVar=NULL;
	POSITION pos = m_pSPMapForm->GetStartPosition();
	while(pos)
	{
		m_pSPMapForm->GetNextAssoc(pos,strID,(void*&)pVar);
		m_pSPMapForm->RemoveKey(strID);
		if(pVar->IsDummy())
		{
			delete pVar;
			pVar = NULL;
		}
		else
			pVar->ReferCount(FALSE);
	}
}

BOOL CXISLOutputBrowser::SetFormMap(CMapStringToPtr *pSPMapForm)
{
	ASSERT(m_pSPMapForm);

	InitFormMap();
	CXISLVar *pVar=NULL;
	CString strID;
	POSITION pos = pSPMapForm->GetStartPosition();
	while(pos)
	{
		pSPMapForm->GetNextAssoc(pos,strID,(void*&)pVar);
		if(m_nOutputEvent == ID_BROWSEREVENT_GET && pVar->IsDummy())
			ASSERT(NULL);//get̂Ƃ̓_~[ϐ͎włȂ

		m_pSPMapForm->SetAt(strID,(void*)pVar);
		pVar->ReferCount(TRUE);
	}
	return TRUE;
}

void CXISLOutputBrowser::GetForm2ListBox(CListCtrl &lbCtrl)
{
	ASSERT(m_pSPMapForm);

	LVITEMA item;

	int nCount=0;
	CString strID;
	CXISLVar *pVar=NULL;
	POSITION pos = m_pSPMapForm->GetStartPosition();
	while(pos)
	{
		m_pSPMapForm->GetNextAssoc(pos,strID,(void*&)pVar);

		item.mask = LVIF_TEXT;
		item.iItem = nCount;
		item.iSubItem = 0;
//		item.lParam = (LPARAM)pVar;
		item.pszText = strID.GetBuffer(strID.GetLength());
		lbCtrl.InsertItem(&item);

		item.mask = LVIF_TEXT;
		item.iSubItem = 1;
		CString strTemp = pVar->GetVarName();
		item.pszText = strTemp.GetBuffer(2);
		lbCtrl.SetItem(&item);

		nCount++;
	}
}

BOOL CXISLOutputBrowser::SetAttribute(int nEvent,LPCTSTR lpszURI,LPCTSTR lpszWName,int nParam1,int nParam2,int nParam3,BOOL bSize)
{
	m_strURI = lpszURI;
	m_strWName = lpszWName;
	m_nOutputEvent = nEvent;
	m_bSize = bSize;
	InitFormMap();
	if(m_pSPMapForm && (m_nOutputEvent != ID_BROWSEREVENT_GET && m_nOutputEvent != ID_BROWSEREVENT_SET))
	{
		delete m_pSPMapForm;
		m_pSPMapForm = NULL;
	}
	switch(m_nOutputEvent)
	{
	case ID_BROWSEREVENT_CLOSE:
	case ID_BROWSEREVENT_MAX:
	case ID_BROWSEREVENT_MIN:
	case ID_BROWSEREVENT_RELOAD:
		break;
	case ID_BROWSEREVENT_MOVE:
		m_nPosition = nParam1;
		break;
	case ID_BROWSEREVENT_RESIZE:
		m_nWidth = nParam1;
		m_nHeight = nParam2;
		break;
	case ID_BROWSEREVENT_NAVI:
		m_nWidth = nParam1;
		m_nHeight = nParam2;
		m_nPosition = nParam3;
		break;
	case ID_BROWSEREVENT_GET:
	case ID_BROWSEREVENT_SET:
		if(m_pSPMapForm == NULL)
			m_pSPMapForm = new CMapStringToPtr;
		break;
	}
	return TRUE;
}

BOOL CXISLOutputBrowser::SetAttribute(LPCTSTR lpszEvent,LPCTSTR lpszParam)
{
	int nEvent=ID_BROWSEREVENT_CLOSE;
	while(1)
	{
		if(strcmp(lpszEvent,XISL_OUTPUT_EVENT[nEvent]) == 0)
			break;

		if(nEvent>ID_BROWSEREVENT_SET)
		{
			AfxMessageBox("`ĂȂeventł",MB_OK|MB_APPLMODAL|MB_ICONEXCLAMATION,0);
			return FALSE;
		}
		nEvent++;
	}

	m_nOutputEvent = nEvent;

	CString strParam = lpszParam;
	CString strParamName;
	CString strTarget;
	CString strValue;
	int nFlag=0;//0 or 1 or 2:<param>Ȃ, 3:OK
	int nIndex=0,nStart=0,nEnd=0;
	while(1)
	{
		nIndex = strParam.Find("<param",nIndex);
		if(nIndex==-1)
		{
			if(nFlag>=3)
				break;
			else
				return FALSE;
		}

		nIndex = strParam.Find("name",nIndex);
		nStart = strParam.Find("\"",nIndex);
		nStart++;
		nEnd = strParam.Find("\"",nStart);
		strParamName = strParam.Mid(nStart,nEnd-nStart);
		if(strParamName.Compare("value")==0 || strParamName.Compare("var")==0)
		{
			nIndex = strParam.Find("target",nIndex);
			if(nIndex==-1)
				return FALSE;
			nStart = strParam.Find("\"",nIndex);
			nStart++;
			nEnd = strParam.Find("\"",nStart);
			strTarget = strParam.Mid(nStart,nEnd-nStart);
		}
		nStart = strParam.Find(">",nEnd);
		nStart++;
		nEnd = strParam.Find("</",nStart);
		strValue = strParam.Mid(nStart,nEnd-nStart);
		nIndex = nEnd + 1;

		if(strParamName.Compare("id")==0)
		{
			m_strWName = strValue;
			if(m_nOutputEvent == ID_BROWSEREVENT_CLOSE || m_nOutputEvent == ID_BROWSEREVENT_MAX
				|| m_nOutputEvent == ID_BROWSEREVENT_MIN || m_nOutputEvent == ID_BROWSEREVENT_RELOAD)
				nFlag=3;
			else
				nFlag++;
		}
		else if(strParamName.Compare("uri")==0)
		{
			if(m_nOutputEvent != ID_BROWSEREVENT_NAVI)
				return FALSE;
			m_strURI = strValue;
			nFlag+=2;
		}
		else if(strParamName.Compare("modal")==0)
		{
			if(m_nOutputEvent != ID_BROWSEREVENT_NAVI)
				return FALSE;
			if(strValue.Compare("on")==0)
				m_bModal = TRUE;
			else
				m_bModal = FALSE;
			nFlag++;
		}
		else if(strParamName.Compare("width")==0)
		{
			if(m_nOutputEvent != ID_BROWSEREVENT_NAVI
				&& m_nOutputEvent != ID_BROWSEREVENT_RESIZE)
				return FALSE;
			m_nWidth = atoi(strValue);
			nFlag++;
		}
		else if(strParamName.Compare("height")==0)
		{
			if(m_nOutputEvent != ID_BROWSEREVENT_NAVI
				&& m_nOutputEvent != ID_BROWSEREVENT_RESIZE)
				return FALSE;
			m_nHeight = atoi(strValue);
			nFlag++;
		}
		else if(strParamName.Compare("position")==0)
		{
			if(m_nOutputEvent != ID_BROWSEREVENT_NAVI
				&& m_nOutputEvent != ID_BROWSEREVENT_MOVE)
				return FALSE;
			int i=0;
			while(1)
			{
				if(strValue.Compare(WINDOW_POSITION[i]) == 0)
				{
					m_nPosition = i;
					nFlag+=2;
					break;
				}
				i++;
				if(i>WPOSITION_RBOTTOM)
					return FALSE;
			}
		}
		else if(strParamName.Compare("var")==0 || strParamName.Compare("value")==0)
		{
			if(m_nOutputEvent != ID_BROWSEREVENT_GET && m_nOutputEvent != ID_BROWSEREVENT_SET)
				return FALSE;
			if(!SetFormMap(strTarget,strValue))
			{
				InitFormMap();
				return FALSE;
			}
			nFlag+=2;
		}
	}

	return TRUE;
}

//void CXISLOutputBrowser::GetDrawString(CString &strText)
//@\@F\peLXg擾
//@FCString :i[p
//ԂlFvoid
void CXISLOutputBrowser::GetDrawString(CString &strText)
{
	switch(m_nOutputEvent)
	{
	case ID_BROWSEREVENT_NAVI:
		strText = "\:\n";
		strText += m_strURI;
		break;
	case ID_BROWSEREVENT_CLOSE:
		strText = "";
		break;
	case ID_BROWSEREVENT_MAX:
		strText = "ő剻";
		break;
	case ID_BROWSEREVENT_MIN:
		strText = "ŏ";
		break;
	case ID_BROWSEREVENT_RELOAD:
		strText = "ēǂݍ";
		break;
	case ID_BROWSEREVENT_RESIZE:
		strText.Format("TCYύX:(w:%d,h:%d)",m_nWidth,m_nHeight);
		break;
	case ID_BROWSEREVENT_MOVE:
		strText = "ړ:";
		strText += WINDOW_POSITION[m_nPosition];
		break;
	case ID_BROWSEREVENT_GET:
		strText = "forml̎擾";
		break;
	case ID_BROWSEREVENT_SET:
		strText = "forml̐ݒ";
		break;
	}
}

//LPCTSTR CXISLOutputBrowsert::GetXISLString()
//@\@FactionȉXISLԂ
//@F
//ԂlFLPCTSTRCXISL
LPCTSTR CXISLOutputBrowser::GetXISLString()
{
	CString strOutputType = XISL_OUTPUT_TYPE[m_nOutputType];
	CString strOutputEvent = XISL_OUTPUT_EVENT[m_nOutputEvent];

	m_strXISL = "<output type=\"" + strOutputType;
	m_strXISL += "\" event=\"";
	m_strXISL += strOutputEvent;
	m_strXISL += "\">\r\n";
	m_strXISL += "<![CDATA[\r\n";

//	int nIndex;
	CString strParam;
	CString strReturn;
	char chrParam[10];
	switch(m_nOutputEvent)
	{
	case ID_BROWSEREVENT_CLOSE:
	case ID_BROWSEREVENT_MAX:
	case ID_BROWSEREVENT_MIN:
	case ID_BROWSEREVENT_RELOAD:
		m_strXISL += "<param name=\"id\">";
		m_strXISL += m_strWName;
		m_strXISL += "</param>\r\n";
		break;
	case ID_BROWSEREVENT_MOVE:
		m_strXISL += "<param name=\"id\">";
		m_strXISL += m_strWName;
		m_strXISL += "</param>\r\n<param name=\"position\">";
		m_strXISL += WINDOW_POSITION[m_nPosition];
		m_strXISL += "</param>\r\n";
		break;
//	case ID_BROWSEREVENT_OPEN:
//		m_strXISL += "<param name=\"id\">";
//		m_strXISL += m_strWName;
//		m_strXISL += "</param>\r\n<param name=\"window-type\">";
//		m_strXISL += WINDOW_TYPE[m_nWType];
//		m_strXISL += "</param>\r\n<param name=\"uri\">";
//		m_strXISL += m_strURI;
//		m_strXISL += "</param>\r\n";
//		break;
	case ID_BROWSEREVENT_RESIZE:
		m_strXISL += "<param name=\"id\">";
		m_strXISL += m_strWName;
		m_strXISL += "</param>\r\n<param name=\"width\">";
		m_strXISL += itoa(m_nWidth,chrParam,10);
		m_strXISL += "</param>\r\n<param name=\"height\">";
		m_strXISL += itoa(m_nHeight,chrParam,10);
		m_strXISL += "</param>\r\n";
		break;
	case ID_BROWSEREVENT_NAVI:
		m_strXISL += "<param name=\"id\">";
		m_strXISL += m_strWName;
		m_strXISL += "</param>\r\n<param name=\"uri\">";
//		nIndex = m_strURI.ReverseFind('\\')+1;
//		m_strXISL += m_strURI.Right(m_strURI.GetLength()-nIndex);
		m_strXISL += m_strURI;
		m_strXISL += "</param>\r\n";
		if(m_bSize)
		{
			m_strXISL += "<param name=\"position\">";
			m_strXISL += WINDOW_POSITION[m_nPosition];
			m_strXISL += "</param>\r\n<param name=\"width\">";
			m_strXISL += itoa(m_nWidth,chrParam,10);
			m_strXISL += "</param>\r\n";
			m_strXISL += "</param>\r\n<param name=\"height\">";
			m_strXISL += itoa(m_nHeight,chrParam,10);
			m_strXISL += "</param>\r\n";
		}
		if(m_strWName.Compare("Main") != 0)
			m_strXISL += "<param name=\"modal\">on</param>\r\n";
		break;
	case ID_BROWSEREVENT_GET:
		GetFormParam(ID_BROWSEREVENT_GET,strParam,strReturn);
		m_strXISL = "<output type=\"" + strOutputType;
		m_strXISL += "\" event=\"";
		m_strXISL += strOutputEvent;
		m_strXISL += "\" return=\"";
		m_strXISL += strReturn;
		m_strXISL += ">\r\n<![CDATA[\r\n";
		m_strXISL += strParam;
		break;
	case ID_BROWSEREVENT_SET:
		GetFormParam(ID_BROWSEREVENT_SET,strParam,strReturn);
		m_strXISL += strParam;
		break;
	default:
		return FALSE;
	}

	m_strXISL += "]]>\r\n</output>\r\n";

	return m_strXISL;
}

void CXISLOutputBrowser::GetFormParam(int nType,CString &strParam,CString &strReturn)
{
	if(m_nOutputEvent != ID_BROWSEREVENT_GET && m_nOutputEvent != ID_BROWSEREVENT_SET)
		return;
	ASSERT(m_pSPMapForm);

	CXISLVar *pVar=NULL;
	CString strID;
	CString strValue;
	strParam = "<param name=\"id\">";
	strParam += m_strWName;
	strParam += "</param>\r\n";
	POSITION pos = m_pSPMapForm->GetStartPosition();
	while(pos)
	{
		m_pSPMapForm->GetNextAssoc(pos,strID,(void*&)pVar);
		pVar->GetVarNameEx(strValue);
		if(nType == ID_BROWSEREVENT_GET)
		{
			strParam += "<param name=\"var\" target=\"";
			strParam += strID;
			strParam += "\">";
			strParam += strValue;
			strParam += "</param>\r\n";
			strReturn += strValue;
		}
		else
		{
			CString strTemp;
			if(!pVar->IsDummy())
			{
				strTemp = "<value expr=\"";
				strTemp += strValue;
				strTemp += "/>";
				strValue = strTemp;
			}
			strParam += "<param name=\"value\" target=\"";
			strParam += strID;
			strParam += "\">";
			strParam += strValue;
			strParam += "</param>\r\n";
		}
	}
}

//BOOL CXISLOutputBrowser::RegistXISLTree(CTreeCtrl *pTree,HTREEITEM hParent)
//@\@Fc[Rg[XISL^Oo^
//@FCTreeCtrl *pTree  :o^c[Rg[
//		  HTREEITEM hParent :eڂ̃nh
//ԂlFBOOL@FTRUE@sFFALSE
BOOL CXISLOutputBrowser::RegistXISLTree(CTreeCtrl *pTree,HTREEITEM hParent)
{
	TVINSERTSTRUCTA tvs;
	TVITEMA tvi;

	tvs.hInsertAfter = TVI_LAST;
	tvi.mask = TVIF_TEXT | TVIF_PARAM | TVIF_IMAGE | TVIF_SELECTEDIMAGE;
	tvs.hParent = hParent;

	//c[ɓo^
	tvi.pszText = XISL_TAG_NAME[ID_TAG_OUTPUT];
	tvi.lParam = (LPARAM)this;
	tvi.iImage = 0;
	tvi.iSelectedImage = 1;
	tvs.item = tvi;
	hParent = pTree->InsertItem(&tvs);
	m_htreeItem = hParent;

	return TRUE;
}

